* Title: 	bls_clean.do
* Version: 	31 May 2018
* Purpose: 	Clean labor force participation data from BLS

*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/bls_clean, replace
set more off
clear all
macro drop _all
pause on

*******************************************************************************
* (1) Load and clean spreadsheet
*******************************************************************************

foreach x in prime_men prime_women {
	
	import excel using dta/raw/bls_raw.xlsx, clear sheet("`x'")
	
	gen flag = (A == "Series ID")
	gen sumflag = sum(flag)
	keep if flag == 0 & sumflag == 1
	
	keep B C D
	ren B year
	ren C month
	ren D lfpr_`x'
	
	replace month = substr(month,2,2)
	destring _all, replace
	gen date = ym(year,month)
	format date %tm
	
	keep  date lfpr_`x'
	order date lfpr_`x'
	tempfile `x'
	save ``x''
	
} 

use `prime_men'
merge 1:1 date using `prime_women', assert(matched) nogen


*******************************************************************************
* (2) End of file
*******************************************************************************

sort date
compress

save dta/bls_clean, replace

log close
exit, clear
